/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.config.json;

import com.fuzs.puzzleslib_em.PuzzlesLib;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonConfigFileUtil {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final int SEARCH_LAYERS = 3;

    public static boolean mkdirs(String modId) {
        return JsonConfigFileUtil.mkdirs(JsonConfigFileUtil.getPath(modId));
    }

    public static boolean mkdirs(File dir) {
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return false;
    }

    public static void getAndLoad(String jsonName, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        File jsonFile = JsonConfigFileUtil.getPath(jsonName);
        JsonConfigFileUtil.load(jsonFile, serializer, deserializer);
    }

    public static void getAndLoad(String jsonName, String modId, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        File jsonFileInDir = JsonConfigFileUtil.getPathInDir(jsonName, modId);
        JsonConfigFileUtil.load(jsonFileInDir, serializer, deserializer);
    }

    public static void getAllAndLoad(String jsonName, Consumer<File> serializer, Consumer<FileReader> deserializer, Runnable prepareForLoad) {
        File jsonDir = JsonConfigFileUtil.getPath(jsonName);
        ArrayList files = Lists.newArrayList();
        JsonConfigFileUtil.createAllIfAbsent(jsonDir, serializer, files);
        JsonConfigFileUtil.loadAllFiles(jsonDir, deserializer, prepareForLoad, files);
    }

    private static void createAllIfAbsent(File jsonDir, Consumer<File> serializer, List<File> files) {
        JsonConfigFileUtil.mkdirs(jsonDir);
        JsonConfigFileUtil.getAllFilesInDir(jsonDir, 3, files, name -> name.endsWith(".json"));
        if (files.isEmpty()) {
            serializer.accept(jsonDir);
        }
    }

    private static void loadAllFiles(File jsonDir, Consumer<FileReader> deserializer, Runnable prepareForLoad, List<File> files) {
        if (files.isEmpty()) {
            JsonConfigFileUtil.getAllFilesInDir(jsonDir, 3, files, name -> name.endsWith(".json"));
        }
        prepareForLoad.run();
        files.forEach(file -> JsonConfigFileUtil.loadFromFile(file, deserializer));
    }

    private static void load(File jsonFile, Consumer<File> serializer, Consumer<FileReader> deserializer) {
        JsonConfigFileUtil.createIfAbsent(jsonFile, serializer);
        JsonConfigFileUtil.loadFromFile(jsonFile, deserializer);
    }

    private static void createIfAbsent(File jsonFile, Consumer<File> serializer) {
        if (!jsonFile.exists()) {
            serializer.accept(jsonFile);
        }
    }

    public static void copyToFile(File jsonFile) {
        JsonConfigFileUtil.mkdirs(jsonFile.getParentFile());
        try (InputStream input = JsonConfigFileUtil.class.getResourceAsStream("/" + jsonFile.getName());
             FileOutputStream output = new FileOutputStream(jsonFile);){
            jsonFile.createNewFile();
            byte[] buffer = new byte[16384];
            int lengthRead = input.read(buffer);
            while (lengthRead > 0) {
                output.write(buffer, 0, lengthRead);
                lengthRead = input.read(buffer);
            }
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Failed to copy {} in config directory: {}", (Object)jsonFile.getName(), (Object)e);
        }
    }

    public static void saveToFile(File jsonFile, JsonElement jsonElement) {
        JsonConfigFileUtil.mkdirs(jsonFile.getParentFile());
        try (FileWriter writer = new FileWriter(jsonFile);){
            GSON.toJson(jsonElement, (Appendable)writer);
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Failed to create {} in config directory: {}", (Object)jsonFile.getName(), (Object)e);
        }
    }

    private static void loadFromFile(File file, Consumer<FileReader> deserializer) {
        try (FileReader reader = new FileReader(file);){
            deserializer.accept(reader);
        }
        catch (Exception e) {
            PuzzlesLib.LOGGER.error("Failed to read {} in config directory: {}", (Object)file.getName(), (Object)e);
        }
    }

    private static void getAllFilesInDir(File directory, int searchLayers, List<File> fileList, Predicate<String> fileNamePredicate) {
        File[] allFilesAndDirs = directory.listFiles();
        if (allFilesAndDirs != null) {
            for (File file : allFilesAndDirs) {
                if (file.isDirectory()) {
                    if (searchLayers <= 0) continue;
                    JsonConfigFileUtil.getAllFilesInDir(file, searchLayers - 1, fileList, fileNamePredicate);
                    continue;
                }
                if (fileList.size() >= 128 || !fileNamePredicate.test(file.getName())) continue;
                try {
                    fileList.add(file);
                }
                catch (Exception e) {
                    PuzzlesLib.LOGGER.error("Failed to locate files in {} directory: {}", (Object)directory.getName(), (Object)e);
                }
            }
        }
    }

    public static File getPath(String jsonName) {
        return new File(FMLPaths.CONFIGDIR.get().toFile(), jsonName);
    }

    public static File getPathInDir(String jsonName, String modId) {
        return new File(FMLPaths.CONFIGDIR.get().toFile(), modId + File.separator + jsonName);
    }
}

